WITH
T AS
(SELECT 1 AS resource_level, 'KEY' AS resource_type,
        'hashed key' AS format_description
 UNION  ALL
 SELECT 1, 'RID', 'file:page:slot'
 UNION  ALL
 SELECT 2, 'PAGE', 'file:page'
 UNION  ALL
 SELECT 3, 'OBJECT', 'object_id'
)
SELECT TL.request_session_id AS session_id, TL.resource_type,
       CASE
          WHEN TL.resource_type IN ('DATABASE', 'FILE', 'METADATA')
             THEN TL.resource_type
          WHEN TL.resource_type = 'OBJECT'
             THEN (SELECT TOP 1 s.name + '.' + o.name
                   FROM   sys.objects AS o
                          INNER JOIN sys.schemas AS s
                                ON o.schema_id = s.schema_id
                   WHERE  o.object_id = TL.resource_associated_entity_id)
          WHEN TL.resource_type IN ('KEY', 'PAGE', 'RID')
             THEN (SELECT TOP 1 s.name + '.' + o.name
                   FROM   sys.objects AS o
                          INNER JOIN sys.schemas AS s
                                ON o.schema_id = s.schema_id
                   WHERE o.object_id = object_id)
          ELSE 'Inconnue'
       END AS "object_name", TL.request_mode AS lock_mode,
       TL.request_status AS lock_status, T.format_description,
       TL.resource_description, resource_associated_entity_id,
       ST."text" AS SQL_command, ER.blocking_session_id,
       ES.status AS session_status, ES.login_name
FROM   sys.dm_tran_locks AS TL
       LEFT OUTER JOIN sys.dm_exec_requests AS ER
             ON TL.request_session_id = ER.session_id
       INNER JOIN sys.dm_exec_sessions AS ES
             ON TL.request_session_id = ES.session_id
       INNER JOIN sys.dm_exec_connections AS EC
             ON TL.request_session_id = EC.session_id
       LEFT OUTER JOIN sys.partitions AS P
             ON TL.resource_associated_entity_id = P.hobt_id
       OUTER APPLY sys.dm_exec_sql_text(EC.most_recent_sql_handle) AS ST
       LEFT OUTER JOIN T
            ON TL.resource_type = T.resource_type
WHERE  TL.request_session_id <> @@SPID
ORDER  BY TL.request_session_id, COALESCE(resource_level, 999);